#' Voronoi Areas
#'
#' Find the Voronoi Areas 
#'
#' @param x coordinates of input data
#' @param y coordinates of input data
#' @param vm Voronoi mosaic from tripack
#'
#' @return An object of class vareas with components:
#' \item{xx}{augmented x coordinates}
#' \item{yy}{augmented x coordinates}
#' \item{zz}{areas}
#' \item{vm}{augmented Voronoi mosaic}
#' @export

"vareas" <-
function(x,y,vm){
 #Augmented points around convex hull
                onhull <- tripack::convex.hull(vm$tri)$i
                onhull <- c(onhull,onhull[1])
                xh <- vm$tri$x[onhull]
                yh <- vm$tri$y[onhull]
                center <- c(mean(xh),mean(yh))
                xaug <- rep(0,length(2*xh))
                yaug <- rep(0,length(2*xh))
		width <- .25*sqrt(max(diff(xh)^2 + diff(yh)^2))
                for(i in 2:length(xh)){
                        a <- xh[i] - xh[i-1]
                        b <- yh[i] - yh[i-1]
                        orth <- c(b, -a)
			orth <- width*orth/c(sqrt(crossprod(orth)))
                        orient <- c(xh[i],yh[i]) - center
                        orth <- sign(c(crossprod(orth,orient)))*orth
                        xaug[2*(i-2)+1:2] <- xh[(i-1):i] + orth[1]
                        yaug[2*(i-2)+1:2] <- yh[(i-1):i] + orth[2]
                        }
                xx <- c(x,xaug)
                yy <- c(y,yaug)
		vm <- tripack::voronoi.mosaic(xx,yy)
		areas <- unlist(tripack::cells(vm))
		areas <- areas[names(areas)=="area"]
		areas <- areas[1:length(x)]
		zz <- c(1/areas,rep(0,length(xaug)))
		Z <- (list(xx = xx, yy = yy, zz = zz, vm = vm))
		class(Z) <- "vareas"
		Z
		}
