#' Plot a voronogram object
#'
#' Given a fitted voronogram plot the mosaic 
#'
#' @param  x is the fitted object
#' @param  ... other arguments to pass to \code{symbols}, notably e.g. \code{add = TRUE}
#' @return nothing (invisibly)
#' @importFrom grDevices palette topo.colors
#' @importFrom graphics plot.new plot.window polygon
#' 
#' @export
"plot.voronogram" <-
function (x, ...) 
{
v <- x
x <- v$x
y <- v$y
fit <- v$fit
tm <- tripack::tri.mesh(x,y)
xlim <- c(min(tm$x) - 0.1 * diff(range(tm$x)), max(tm$x) + 0.1 * diff(range(tm$x)))
ylim <- c(min(tm$y) - 0.1 * diff(range(tm$y)), max(tm$y) + 0.1 * diff(range(tm$y)))
plot.new()
plot.window(xlim = xlim, ylim = ylim, "")
n <- length(x)
vm <- tripack::voronoi.mosaic(x,y)
palette(topo.colors(256))
#palette(grey(seq(0,.99,len=100)))
#map fit to colors -- the .01 avoids getting zero and hence an uncolored polygon
cfit <- 256*(fit - min(fit) + .01)/(max(fit)-min(fit))
for(i in 1:n){
        vpolygon <- vfind(i,vm)
        if(length(vpolygon)){
                xx <- vm$x[vpolygon]
                yy <- vm$y[vpolygon]
                inhull <- tripack::in.convex.hull(tm,xx,yy)
                polygon(xx[inhull],yy[inhull] ,col=cfit[i],border="NA")
                #polygon(xx[inhull],yy[inhull] ,col=cfit[i])
                }
        }
}
