% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medde2.R
\name{medde2}
\alias{medde2}
\title{Maximum Entropy [De]Regularized [Bivariate] Density Estimation}
\usage{
medde2(x, m = x, wt = rep(1, length(x)), w, mass = 1, alpha = 1,
  rtol = 1e-06, verb = 0, control = NULL)
}
\arguments{
\item{x}{Data: n by 2 matrix of observations}

\item{m}{Undata: N by 2 matrix of points at which the estimate is to be
evaluated, by default equal to x.}

\item{wt}{weights associated with x points, must be positive.}

\item{w}{integration weights: coefficients w_i that give sum f_i w_i = 1}

\item{mass}{norming constant to obtain a density}

\item{alpha}{Renyi entropy parameter characterizing fidelity criterion
by default 1 is log-concave and 0.5 is Hellinger, and so forth}

\item{rtol}{Convergence tolerance for Mosek algorithm,}

\item{verb}{Parameter controlling verbosity of solution, 0 for silent, 5
gives rather detailed iteration log.}

\item{control}{Mosek control list}
}
\value{
An object of class "medde2" with components 
\item{m}{points of evaluation on the domain of the density} 
\item{f}{function values of the estimated density at the evaluation points m} 
\item{g}{estimation function values of the transformed density at points m}   
\item{x}{original data points}
\item{w}{integration weights}
\item{alpha}{Renyi exponent}
\item{status}{exit status from Mosek}
}
\description{
Bivariate density estimation based on maximum entropy methods
}
\details{
See the references for further details. And also Mosek "Manuals". The
acronym, according to the urban dictionary has a nice connection to
a term used in Bahamian dialect, mostly on the Family Islands like Eleuthera
and Cat Island meaning "mess with" "get involved," "get entangled," "fool
around," "bother:"
"I don't like to medder up with all kinda people"
"Don't medder with people (chirren)"
"Why you think she medderin up in their business."

This version implements a class of shape constrained bivariate density estimators. 
The form of the shape constraint is controlled by the parameter \eqn{\alpha}
Setting \eqn{\alpha = 1}, 
constrains the fitted density to be log-concave; for \eqn{\alpha = 0.5},  \eqn{-1/\sqrt f}
is constrained to be concave; and for \eqn{\alpha \le 0}, \eqn{1/f^{\alpha -1}} is
constrained to be concave.  In these cases no further regularization of the smoothness
of density is required as the concavity constraint acts as  regularizer.
As explained further in Koenker and Mizera (2010) and
Han and Wellner (2016) decreasing \eqn{\alpha} constrains the fitted density to lie 
in larger classes of quasi-concave
densities.  See \code{demo(Gosset)} for an illustration of these options, but be aware
that more extreme \eqn{\alpha} pose more challenges from an numerical optimization
perspective.  Fitting for \eqn{\alpha < 1} employs a fidelity criterion closely 
related to Renyi entropy that is more natural than likelihood for very peaked, or very heavy
tailed target densities.  No provision is made for bivariate norm constraints (yet).
}
\references{
Han, Qiyang and Jon Wellner (2016) ``Approximation and estimation of s-concave 
densities via Renyi divergences, \emph{Annals of Statistics}, 44, 1332-1359.
Koenker, R and I. Mizera, (2010) ``Quasi-Concave Density Estimation''
\emph{Annals of Statistics}, 38, 2998-3027.
}
\seealso{
A plotting method is available, see \code{plot.medde2}
}
\author{
Roger Koenker and Ivan Mizera
}
\keyword{nonparametric}
