% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggrid.R
\name{ggrid}
\alias{ggrid}
\title{Interpolation function for bivariate Renyi fitting}
\usage{
ggrid(x, y, px, py, tolbe = 1e-04)
}
\arguments{
\item{x}{original data points (n by 2 matrix)}

\item{y}{fitted g function values at x points}

\item{px}{grid of x values for interpolation}

\item{py}{grid of y values for interpolation}

\item{tolbe}{tolerance parameter for csurf}
}
\value{
A matrix of interpolated function values
}
\description{
Bivariate Renka interpolation for Renyi fitting
}
\details{
This is an interpolation procedure intended for contour plotting
or surface visualization via rgl, or some other schema.  Given
function values of a transformed density \eqn{y = g(x)} at scattered points 
\eqn{x}, as produced by \code{medde2}, satisfying  a convexity constraint, 
we want to find interpolated values of \eqn{g} on a lattice \eqn{p_x \times p_y}.
The algorithm and implementation is based on Renka's (2004) CSRFPACK, which is
unfortunately licensed under the TOMS "for non-commercial use" scheme, and consequently 
cannot appear on CRAN.
}
\references{
Renka RJ. 2004. Algorithm 833: {CSRFPACK} interpolation of 
scattered data with a {C1} convexity-preserving surface. \emph{ACM TOMS} 
30: 200 -- 211.
}
\author{
Roger Koenker
}
\keyword{nonparametric}
