# Mixture of log normals example from ancient 574 problem set
rlambda <- function(n, mu = c(0.5, 1.1, 2.6), sigma = c(0.2, 0.3, 0.2), 
	 alpha = c(0.4, 1.2, 2.4), w = c( 0.33, 0.33, 0.34))
{ #mixture of lognormals -- random numbers
  #No error checking!  w is a weight vector which should add to one.
  m <- length(w)
  w <- cumsum(w)
  U <- runif(n)
  W <- matrix(0, n, m)
  W[, 1] <- U < w[1]
  for(i in 2:m) {
      W[, i] <- (U < w[i]) & (U >= w[i - 1])
     }
  z <- rep(0, n)
  for(i in 1:m) {
      z <- z + W[, i] * (alpha[i] + exp(rnorm(n, mu[i], sigma[i])))
     }
  z
}
dlambda <- function(z, mu = c(0.5, 1.1, 2.6), sigma = c(0.2, 0.3, 0.2), 
	 alpha = c(0.4, 1.2, 2.4), w = c( 0.33, 0.33, 0.34), eps = 0.0001)
{
#mixture of lognormals density function
m <- length(w)
f <- 0 * z
for(i in 1:m) 
    f <- f + (w[i] * dnorm(log(pmax(z - alpha[i], eps)), mu[i], 
			 sigma[ i]))/((z - alpha[i]))
f
}

require(latticeExtra) # Thanks to Richard Heiberger for R-help with this!
alphas <- 0:1
set.seed(17)
x <- rlambda(500)
z <- seq(0,max(x), length=2000)
M <- function(alpha) medde(x, v = 1000, lambda = 8, alpha, Dorder = 2, rtol = 1e-8)
H <- histogram( ~ x, nint = 200, border = grey(.9), col = grey(.9), ylim = c(0, 0.05), type = "density")
f0 <- xyplot(dlambda(z) ~ z, type = "l", col = "red", lwd = 1.5)
f <- lapply(alphas, FUN=M) 
fplot <- lapply(f, FUN = function(z) xyplot(z$y ~ z$x, type="l", col="blue", lwd=1.5)) 
names(fplot) <- alphas
Hfplot <- c(H+f0+fplot[[1]], H+f0+fplot[[2]], x.same = TRUE, y.same = TRUE) 
Hfplot <- update(Hfplot, strip=strip.custom(factor.levels = expression(alpha == 0, alpha == 1)))
print(Hfplot)


