# Bivariate example based on Gosset's crimtab data
set.seed(1729)

# Test on binned finger data alpha = 1
D <- crimtab
x <- as.numeric(rownames(D))
y <- as.numeric(colnames(D))
x <- rep(x, 22)
y <- rep(y, each = 42)
wt <- c(D)
s <- (wt != 0)
x <- x[s]
y <- y[s]
wt <- wt[s]
n <- length(x)
XY <- data.frame(x = x,y = y)
# jittered binned data
x <- cbind(x + runif(n)/500,y + runif(n)/50) # dither to avoid latticed data

rx <- range(x[,1])
ry <- range(x[,2])              
px <- seq(rx[1],rx[2],length = 300)
py <- seq(ry[1],ry[2],length = 300)

m <- x  

dd <- 10000       # larger dd is more precise takes longer 
d = cbind( runif(dd,rx[1],rx[2]), runif(dd,ry[1],ry[2]))
ma <- (rx[2]-rx[1])*(ry[2]-ry[1])
w <- apply(neinn(d,m),2,mean)*ma # can do it better, but for now ok
res <- medde(x=x, m=m, wt = wt, w=w, alpha=1, verb = 5)

require(tripack)
Z <- ggrid(x, res$g, px, py)
xyd <- data.frame(x = jitter(rep(XY[,1], wt), 5), y = jitter(rep(XY[,2], wt), 5))
xlab <- "Length of Left Middle Finger (cm)"
ylab <- "Height (cm)"
plot(xyd, cex = .2, col = "grey", xlab = xlab, ylab = ylab)
T <- tri.mesh(xyd)
hull <- convex.hull(T, plot.it = TRUE, col = "blue", xlab = xlab, ylab = ylab, add = TRUE)
points(hull$x, hull$y,pch = 16)
G <- expand.grid(px,py)
s <- in.convex.hull(T,G[,1],G[,2])
Z[matrix(!s,length(px),length(py))] <- 1000 
contour(px, py, -Z, labcex = 1, levels = c(-(3:6), -8,-10,-15,-20), add = TRUE)
text(px[124] - 0.2, py[290], -round(Z[124, 290]), col = "darkorange2") # log density at the fanta-faced falangist
title("Log Concave Density Estimate for Student's Data")

