
# Analysis of the sim.R results

load("sim6.Rda")
require(quantreg)

# Bias Tables

# Intercept Parameter

B0 <- apply(A[1,,,]-5,1:2,mean)

# Slope Parameter

B <- A[2,,,] + 2 * A[3,,,] - 1
B1 <- apply(B,1:2,mean)

# MAE Tables
#
# Intercept Parameter

MAE0 <- apply(abs(A[1,,,]-5),1:2,median)

# Slope Parameter

B <- A[2,,,] + 2 * A[3,,,] - 1
MAE1 <- apply(abs(B),1:2,median)
#
# RMSE Tables
#
# Intercept Parameter

RMSE0 <- sqrt(apply((A[1,,,]-5)^2,1:2,mean))

# Slope Parameter

B <- A[2,,,] + 2 * A[3,,,] - 1
RMSE1 <- sqrt(apply(B^2,1:2,mean))

S6 <- cbind(c(t(B0)),c(t(MAE0)),c(t(RMSE0)),c(t(B1)),c(t(MAE1)),c(t(RMSE1)))


rnames <- rep(paste("$n = ",c(100,400,1000),"$"),4)
cnames <- rep(c("Bias","MAE","RMSE"),2)
dimnames(S6) <- list(rnames,cnames)
cgroup <- c("Intercept","Slope")
rgroup <- c( "Portnoy","Peng-Huang","Powell", "GMLE")
caption = c("Comparison of Performance for the iid $t_3$ Error, 
	Variable Censoring Configuration")
latex.table(S6,file = "S6",rowlabel="",cgroup=cgroup,rgroup=rgroup,
	label = "tabS6",dec = 4,caption=caption)

