# Simulation Design for crq paper

dgp <- function(x,ctype,b = c(5,1,.3),a = c(6.5,5.5,.75,.3)){
	n <- length(x)
	T <- b[1] + b[2] * x + b[3] * (b[3] + x^2) * rnorm(n)
	if(ctype == 1) C <- rep(a[1],n)
	else C <- a[2] + a[3] * x + a[4] * rnorm(n)
	Y <- pmin(T,C)
	d <- T < C
	list(T=T, C=C, Y=Y, d=d)
	}

# Testing/plotting 
n <- 100
set.seed(1968)
x <- sort(runif(n) * 2)
pdf("figsim1.pdf",height = 5, width = 8)
par(mfrow = c(1,2))
for(j in 1:2){
z <- dgp(x,j)
plot(x,z$Y,ylim = c(4,8),ylab ="Y",type="n")
taus <- 1:9/10
s <- z$d
points(x,z$Y,cex = .7)
points(x[s],z$Y[s],cex=.7,pch = 19)
for(i in 1:9){
	tau <- taus[i]
	b <- c(5,1,.3)
	y <-  b[1] + b[2] * x + b[3] * (b[3] + x^2) * qnorm(tau)
	if(i == 5) lines(x,y)
	else lines(x,y,col = "grey")
	}
}
dev.off()
