require(quantreg)
pdf("Ex2.pdf",height=6, width=6)
data(uis)

formula <-  ~  ND1 + ND2 + IV3 + TREAT + FRAC + RACE + AGE * SITE -1
X <- data.frame(model.matrix(formula,data=uis))
newd <- as.list(apply(X,2,median))
pred <- predict(fit, newdata=newd, type = "stepfun")
plot(pred,do.points=FALSE,xlab = expression(tau), ylab = expression(Q(tau)),main= "Quantiles at Median Covariate Values")
plot(rearrange(pred),add=TRUE,do.points=FALSE,col.vert ="red", col.hor="red")
legend(.15,7,c("Raw","Rearranged"),lty = rep(1,2),col=c("black","red"))
dev.off()
