######  generate data from log linear model (AFT model) ######

dgp <- function(n, b) {  
  x1 <- runif(n) 
  x2 <- runif(n) < 0.5
  u <- log(rexp(n))
  T <- exp(x1*b[1] + x2*b[2] + u)
  C0 <- runif(n, 0, 3.8)
  C1 <- runif(n, 0.1, 3.8)
  C <- C0 * (1 - x2) + C1 * x2  # 25% censoring
  Y <- pmin(T, C)
  D <- T <= C
  data.frame(Y, D, x1, x2)
}



ns <- c(100, 400, 1600)
gs <- c(2:9/10)
nn <- length(ns)
b <- c(0.5, -0.5)
R <- 1000
H <- expand.grid(ns,gs,1:R)
N <- nrow(H)
A <- array(NA,c(4,4,N))
B <- array(NA,c(4,4,N))

require(quantreg)

system("hostname")
date()
sessionInfo()
set.seed(1968)

for(i in 1:N){
  n <- H[i,1]
  d <- dgp(n, b)  
  g <- H[i,2]
  G <- floor(n^g) + 5
  grid <- 1:G/(G+1)
  A[,,i] <-  coef(crq(Surv(log(Y),D) ~ x1 + x2, data = d, method= "P",grid = grid))
  B[,,i] <-  coef(crq(Surv(log(Y),D) ~ x1 + x2, data = d, method="PH",grid = grid))
  print(H[i,])
 }
