#  	 mmm[i,j] <- median(t)
#        mpo[i,j] <- Powell.median(y,cen)
#        mkm[i,j] <- KM.median(y,t < cen)
#  	 mna[i,j] <- NA.median(y,t < cen)
#        ml1[i,j] <- L.median(y,cen)
#        ml2[i,j] <- L.median(y,cen,ecdf=FALSE)
#Some tables....
BiasTab <- matrix(0,6,4)
BiasTab[1,] <- apply(mmm,2,mean) -1
BiasTab[2,] <- apply(mkm,2,mean) -1
BiasTab[3,] <- apply(mna,2,mean) -1
BiasTab[4,] <- apply(mpo,2,mean) -1
BiasTab[5,] <- apply(ml1,2,mean) -1
BiasTab[6,] <- apply(ml2,2,mean) -1
VarTab <- matrix(0,6,4)
VarTab[1,] <- apply(mmm,2,var) 
VarTab[2,] <- apply(mkm,2,var)
VarTab[3,] <- apply(mna,2,var)
VarTab[4,] <- apply(mpo,2,var)
VarTab[5,] <- apply(ml1,2,var)
VarTab[6,] <- apply(ml2,2,var)
MSETab <- matrix(0,6,4)
MSETab[1,] <- apply((mmm - 1)^2,2,mean)
MSETab[2,] <- apply((mkm - 1)^2,2,mean)
MSETab[3,] <- apply((mna - 1)^2,2,mean)
MSETab[4,] <- apply((mpo - 1)^2,2,mean)
MSETab[5,] <- apply((ml1 - 1)^2,2,mean)
MSETab[6,] <- apply((ml2 - 1)^2,2,mean)
VarTab <- t(VarTab)* ns
MSETab <- t(MSETab)* ns
source("Avar.R")
MSETab <- rbind(MSETab,c(M.Avar,KM.Avar(200),KM.Avar(200),P.Avar, P.Avar, L.Avar))
MSETab <- format(round(MSETab,3))
dimnames(MSETab) <- list(c(paste("$n=",ns,"$",sep=""),"$n=\\infty$"),
c("median","Kaplan-Meier","Nelson-Aalen", "Powell","Leurgans $\\hat G$","Leurgans $G$"))
caption = "Scaled MSE for Several Estimators of the Median:
Mean squared error estimates are scaled by sample size
to conform to asymptotic variance computations." 
require(quantreg)
latex.table(x = MSETab, rowlabel = "", n.rgroup = c(4,1), caption = caption)

