#Avar calculation of the median of the kaplan meier estimator
# with
#	F ~ standard lognormal (median is 1)
#	G ~ exponential with rate .25
#
#	Ftilde = int_0^t (1 - G(s))dF(s)
#
#	Avar = [ 2 f(median)]^{-2} int_0^t (1-H(s))^{-2} dFtilde(s)
#where
#	Hbar(s) == 1-H(s) = (1-G(s))(1-F(s))
#
#Ref.  Miller (1981)

integrand <- function(x, rate = .25)
	(1- pexp(x,rate)) * dlnorm(x)
Ftilde <- function(t){
	v <- t
	for(i in 1:length(t)){
		v[i] <-	integrate(integrand,0,t[i])$value
		}
	v
	}
#Now find Avar
Hbar <- function(t)
	(1 - plnorm(t))*(1 - pexp(t, .25))
KM.Avar <- function(n){
	t <- 1:n/n  #need to integrate to one, not 1/2, -- stupid!
	hbar <- Hbar(t)
	hbar <- (hbar[-1] + hbar[-n])/2
	dFtilde <- diff(Ftilde(t))
	sum(dFtilde/hbar^2)/(4*dlnorm(1)^2)
	}
P.Avar <- 1/((1-pexp(1, .25))*4*dlnorm(1)^2)
L.Avar <- Hbar(1)*(1-Hbar(1))/(dlnorm(1)*(1-pexp(1, .25)))^2
M.Avar <- 1/(4*dlnorm(1)^2)
