# Simulate survival distributions for NCAA Tournament
SBracket <- function(QBFit, Tournament, R = 100, seed = NULL, ...) {
    if(!length(seed)) set.seed(seed)
    A <- list()
    for(i in 1:R){
	W <- Bracket(QBFit, Tournament)
	g <- lapply(W[2:7], function(x) x$winners[,2]) 
	A[[i]] <- table(unlist(g))
    }
    B <- do.call("cbind", A) # Not a very friendly R-idiom
    D <- apply(B,1, tabulate, nbins = 6)
    D <- D[,apply(D,2,sum) != 0] 
    D <- apply(D,2,function(x) rev(cumsum(rev(x)))) # Another exotic idiom
    D <- D[,order(-apply(D,2,mean))]
    Stab <- t(D)/R 
    class(Stab) <- "SBracket"
    Stab # Returns matrix of survival frequencies
}

plot.SBracket <- function(x, ...){

    grid.newpage()
    pushViewport(viewport(width=.8,height=.8))
    # partition the plot areas
    pushViewport(viewport(layout = grid.layout(29,4)))
    grid.rect(gp=gpar(col="grey"))
    #main title
    pushViewport(viewport(layout.pos.col = 1:4, layout.pos.row = 1:2))
    grid.rect(gp=gpar(col="gray", fill="lightblue"))
    grid.text("NCAA Tournament Survival Curves")
    popViewport()
    
    #Team Names
    TTeams <- dimnames(x)[[1]]
    for(i in 1:54){
	    if(i < 28){
		    col <- 1
		    row <- i
	    } else{
		    col <- 3
		    row <- i - 27
	    }
	    pushViewport(viewport(layout.pos.col = col, layout.pos.row = 2 + row))
	    grid.rect(gp=gpar(col="gray", fill="cornsilk"))
	    grid.text(TTeams[i],gp=gpar(fontsize=9, col=gray(0.1)))
	    popViewport()
	    }
    # Survival Curves
    
    xx <- c(rep(0:6,each=2),0)
    for(i in 1:54){
	    if(i < 28){
		    col <- 1
		    row <- i
	    } else{
		    col <- 3
		    row <- i - 27
	    }
	    y <- c(0,rep(x[i,],each=2),0,0)
	    pushViewport(viewport(layout.pos.col = 1 + col,
		    layout.pos.row = 2 + row, xscale=c(0,6), yscale=c(0,1)))
	    grid.rect(gp=gpar(col="gray" ))
    
	    grid.polygon(xx,y,gp=gpar(fill="bisque"),default.units="native")
	    popViewport()
	    }
}
