# Monte Carlo simulation a la Ruppert Carroll and Wand Section 17.5.1

# The nonparametric target function(s) as j gets larger g0 has larger total variation
g0 <- function(x, j) sqrt(x *(1-x)) * sin(2*pi*(1 + 2^((9-4*j)/5))/(x + 2^((9-4*j)/5)))

# Some initializations
   plotit = FALSE
   if(plotit){
      X11(width = 9, height = 4)
      par(ask = FALSE)
      par(mfrow = c(1,2))
      }
   require(mgcv)
   require(ConfBands)
   require(quantreg)
   #source("plot.rqss.R") # Modified rqss to return pd and to plot 2se bands.
   source("plot.gam.R") # Modified gam to return pd and to plot 2se bands.
   source("plot.scbm.R") # Modified ConfBands function to return bands, 
   options(warn = -1) # turn off warnings about tiny diagonals


   fitrqss <- function(x,y,g0 = NULL){
     g <- function(lam,y,x) AIC(rqss(y ~ qss(x, lambda = lam)),k = -1) 
     lamstar <- optimize(g, interval = c(0.001, .5), x = x, y = y)
     f <- rqss(y ~ qss(x, lambda = lamstar$min))
     B <- plot(f, bands = "uniform")
     bandh <- B[[1]]
     B <- plot(f,add = TRUE, bands = TRUE)
     bandg <- B[[1]]
     gtrue <- g0(bandg$x,4)
     lines(bandg$x, gtrue, col = "red")
     ghat <- (bandg$bhi + bandg$blo)/2
     gmise <- mean((ghat - gtrue)^2)
     gmiae <- mean(abs(ghat - gtrue))
     gcove <- 1 - mean((gtrue < bandg$blo) | (gtrue > bandg$bhi))
     hcove <- 1 - mean((gtrue < bandh$blo) | (gtrue > bandh$bhi))
     c(gmise, gmiae, gcove, hcove, attributes(lamstar$objective)$edf)
     }
   fitmgcv <- function(x,y,g0 = NULL){
     gfit <- gam(y ~ s(x, bs = "os", k = 40)) # ConfBands needed for O-splines
     h <- scbM(gfit)
     g <- plot(gfit, shift = gfit$coef["(Intercept)"], seWithMean = TRUE)
     Hband <- plot(h, grid = 100)
     x <- g[[1]]$x
     gtrue <- g0(x,4) 
     x <- Hband[,1]
     htrue <- g0(x,4) 
     lines(x,gtrue,col = "red")
     title("MGCV Estimate")
     ghat <- g[[1]]$fit + gfit$coef["(Intercept)"]
     blo <- ghat -  g[[1]]$se
     bhi <- ghat +  g[[1]]$se
     ghat <- (bhi + blo)/2
     gmise <- mean((ghat - gtrue)^2)
     gmiae <- mean(abs(ghat - gtrue))
     gcove <- 1 - mean((gtrue < blo) | (gtrue > bhi))
     hcove <- 1 - mean((htrue < Hband[,2]) | (htrue > Hband[,3]))
     c(gmise, gmiae, gcove, hcove, sum(gfit$edf))
     }

# Now the setup for the simulation
date()
system("hostname")
sessionInfo()
set.seed(1900)
R <- 1000
n <- 400
x <- sort(runif(n))
Models <- c(M1,
sigma <- 0.2
A <- array(0,c(5,2,R))
for(i in 1:R){
   y <- g0(x,4) + rt(n,3)*(sigma*(1 + x))
   A[,1,i] <- fitrqss(x,y, g0)
   A[,2,i] <- fitmgcv(x,y, g0)
   print(i)
   }
