# Conformal bands for rqss
conformal <- function(formula, taus = c(0.05, 0.95), newdata, split = 0.5,
			data = parent.frame(), method = "fn", ...){

    D <- data[,all.vars(formula)]
    s <- c(1,2,sample(1:nrow(D), floor(split * nrow(D))))
    qlo <- rqss(formula, tau = taus[1], data = D[s,], method = method, ...)
    qhi <- rqss(formula, tau = taus[2], data = D[s,], method = method, ...)
    x2 <- D[-s,]
    y2 <- D[-s,1]
    ylo2 <- predict(qlo, newdata = x2)
    yhi2 <- predict(qhi, newdata = x2)
    E <- pmax(ylo2 - y2, y2 - yhi2)
    QE <- quantile(E, diff(taus))
    pred <- NULL
    if(!missing(newdata))
	pred <- cbind(predict(qlo, newdata = newdata) - QE,
		  predict(qhi, newdata = newdata) + QE)
    list(qlo = qlo, qhi = qhi, QE = QE, pred = pred)
}

